;VBXE CONFIG UTILITY !
;EP1K50 Direct Configurator

        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'

EP_DATA         equ OR0
EP_DCLK         equ OR1
EP_NCONFIG      equ OR2
EP_CFG2         equ OR7
EP_CONF_DONE    equ OR7
VBXECR          equ $d7ff ;!!!!

        _TEST = 0

        opt     l+
        org     $8000

        .if     _TEST

init    rts

start
        ldx     <weltxt
        ldy     >weltxt
        jsr     PUTLINE

        ldy     #0
        ldx     #0

l1      txa
        and     #7
        sta     VBXECR
        eor     VBXECR
        and     #7
        bne     port_error
        inx
        bne     l1
        iny
        bne     l1

        ldx     <oktxt
        ldy     >oktxt
        jmp     PUTLINE
port_error
        ldx     <errtxt
        ldy     >errtxt
        jmp     PUTLINE

weltxt  dta     c'VBXE11 Port tester v0.01',$9b
oktxt   dta     c'Port test passed successfully',$9b
errtxt  dta     c'Port test failed',$9b

        .else   ;_TEST

;----------------------------------------------------------------------------

;dlen            equ 59215    ;dlugosc pliku konfiguracyjnego dla EP1K30
dlen            equ 98023


;words
length  equ     $90
actlen  equ     $92

;bytes
temp    equ     $a0
lengthx equ     $a1

buffer  equ     $4000
blength equ     $4000


weltxt  dta     c'VBXE1x PS CfgR v2.01 (D7xx)',$9b

init    ldx     <weltxt
        ldy     >weltxt
        jmp     PUTLINE

        ini     init

        org     $8000

start   lda     <dlen
        sta     length
        lda     >dlen
        sta     length+1
        lda     ^dlen
        sta     lengthx
        lda     <buffer+blength
        sta     actlen
        lda     >buffer+blength
        sta     actlen+1

        jsr     ep1k_init
        jmi     no_ack
        ldx     #$20
        lda     <filename
        sta     ICBAL,x
        lda     >filename
        sta     ICBAH,x
try     jsr     OpenFile
        jpl     autoload
        cpy     #170
        jne     file_error
        jsr     CloseFile
        WinSetup #winbuf
        FileBoxExecute #fmask #dirbuf #dirbuf_len
        jmi     ep1k_close
        ldx     #$20
        lda     <fm.fname
        sta     ICBAL,x
        lda     >fm.fname
        sta     ICBAH,x
        jmp     try
autoload
        jsr     ep1k_check
        jmi     no_ack
        jsr     ep1k_program
        bmi     file_error
        jsr     CloseFile
        jsr     ep1k_usermode
        bmi     no_ack
        jsr     ep1k_close
        ldx     <dontxt
        ldy     >dontxt
        jmp     PUTLINE
file_error
        jsr     ep1k_close
        ldx     <errtxt
        ldy     >errtxt
        jsr     PUTLINE
        jmp     CloseFile
no_ack  jsr     ep1k_close
        ldx     <devtxt
        ldy     >devtxt
        jmp     PUTLINE

OpenFile
        ldx     #$20
        lda     #CIO_open
        sta     ICCOM,x
        lda     #1
        sta     ICBLH,x
        lda     #CIO_read
        sta     ICAX1,x
        jmp     CIOMAIN

ReadBlock
        ldx     #$20
        lda     #CIO_getdata
        sta     ICCOM,x
        lda     <buffer
        sta     ICBAL,x
        lda     >buffer
        sta     ICBAH,x
        lda     <blength
        sta     ICBLL,x
        lda     >blength
        sta     ICBLH,x
        jmp     CIOMAIN

CloseFile
        ldx     #$20
        lda     #CIO_close
        sta     ICCOM,x
        jmp     CIOMAIN

;-----------------------------------------
ep1k_init
        ; ustawiam timeout
        ; x - modszy
        ; y - starszy
        ldx     #255
        ldy     #5
        ; wysyam do kontrolera sygna "zwolnij rejestr" (CFG2 = 0)
        ; oraz ustawiam lini DATA na 1 dla sprawdzenia za chwil
ep1ki1  lda     #EP_NCONFIG+EP_DATA
        sta     VBXECR
        ; czekaj na gotowo VBXE
        ; czyli do DATA = 1, NCONFIG = 1
        txa
        sne
        dey
        dex
        tya
        spl
        rts
        lda     VBXECR
        eor     #EP_DATA+EP_NCONFIG
        and     #EP_DATA+EP_NCONFIG
        jne     ep1ki1
        ; jest DATA = 1, NCONFIG = 1
        ; ustawiam NCONFIG = 1, DATA = 0, DCLK = 0, CFG2 = 0
        lda     #EP_NCONFIG
        sta     VBXECR
        ; sprawdzam, czy rzeczywicie steruj liniami
        ; NCONFIG powinno by teraz = 1 i DATA = 0;
        lda     VBXECR
        eor     #EP_NCONFIG
        and     #EP_DATA+EP_NCONFIG
        jne     ep1ki1
        ; VBXE gotowe
        rts

ep1k_check
        ; sprawdzam, czy potrafi wprowadzi FPGA w tryb konfiguracji
        ; ustawiam NCONFIG = 0, DATA = 0, DCLK = 0, CFG2 = 0
        ldx     #0
        stx     VBXECR
        dex
        rne
        lda     VBXECR
        and     #EP_CONF_DONE
        jne     ep1kc1
        ; ok, CONF_DONE = 0 czyli mog zaczyna konfiguracj
        ; ustawiam NCONFIG z powrotem na 1
        lda     #EP_NCONFIG
        sta     VBXECR
        dex
        rne
        rts
ep1kc1  lda     #$ff
        rts

ep1k_usermode
        lda     VBXECR
        eor     #EP_CONF_DONE
        and     #EP_CONF_DONE
        sne
        rts
        lda     #$ff
        rts

ep1k_close
        lda     #EP_NCONFIG
        sta     VBXECR
        rts

;epd0    ldx     #10
;epd1    lda     #ep_nconfig+ep_dclk
;        sta     VBXECR
;        lda     #ep_nconfig
;        sta     VBXECR
;        dex
;        bne     epd1

ep1k_program
        jsr     GetByte
        bmi     ep1k310
        sta     temp
        ldx     #8
        lda     #ep_nconfig
ep1k300 lsr     temp
        bcc     ep1k301
        ora     #ep_data
ep1k301 sta     VBXECR
        ora     #ep_dclk
        sta     VBXECR
        lda     #ep_nconfig
        sta     VBXECR
        dex
        bne     ep1k300
        lda     length
        bne     ep1k303
        lda     length+1
        bne     ep1k304
        dec     lengthx
ep1k304 dec     length+1
ep1k303 dec     length
        lda     length
        ora     length+1
        ora     lengthx
        bne     ep1k_program
ep1k310 rts

GetByte
        lda     actlen
        eor     <blength+buffer
        bne     gb1
        lda     actlen+1
        eor     >blength+buffer
        bne     gb1
        jsr     ReadBlock
        bpl     gb2
        cpy     #136
        beq     gb2
        tya
        rts
gb2     lda     <buffer
        sta     actlen
        lda     >buffer
        sta     actlen+1
gb1     ldy     #0
        lda     (actlen),y
        inc     actlen
        bne     *+4
        inc     actlen+1
        iny
        rts

;----------------------------------------------
init2   ldx     ZIOCB
        lda     HATABS,x
        sta     filename
        lda     ZIOCB+1
        ora     #'0'
        sta     filename+1
        jmp     FIleBoxInit

filename dta c'D1:EP1K50.RBF',$9b
fmask   dta c'*.*',$9b

errtxt  dta     c'Disk IO error',$9b
dontxt  dta     c'Cfg Data transferred',$9b
devtxt  dta     c'No acknowledge from FPGA',$9b

        icl     'filebox.asm'

dirbuf_len      equ     0x1000

dirbuf  equ     *
winbuf  equ     *+dirbuf_len

        ini     init2

        .endif  ;_TEST

        run     start

        end
